/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.util.Collections;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.stalactite.dsl.naming.MapEntryTableNamingStrategy;
import org.codefilarete.stalactite.engine.model.City;
import org.codefilarete.stalactite.engine.model.Country;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.collection.Iterables;
import org.junit.jupiter.api.Test;

class MapEntryTableNamingStrategyTest {
    MapEntryTableNamingStrategyTest() {
    }

    @Test
    void giveName() {
        MapEntryTableNamingStrategy.DefaultMapEntryTableNamingStrategy testInstance = new MapEntryTableNamingStrategy.DefaultMapEntryTableNamingStrategy();
        Assertions.assertThat((String)testInstance.giveTableName(new AccessorDefinition(Country.class, "getCities", City.class), String.class, Integer.class)).isEqualTo("Country_cities");
        Assertions.assertThat((String)testInstance.giveTableName(new AccessorDefinition(Country.class, "giveCities", City.class), String.class, Integer.class)).isEqualTo("Country_giveCities");
    }

    @Test
    void giveMapKeyColumnNames() {
        MapEntryTableNamingStrategy.DefaultMapEntryTableNamingStrategy testInstance = new MapEntryTableNamingStrategy.DefaultMapEntryTableNamingStrategy();
        Table cityTable = new Table("cityTable");
        cityTable.addColumn("id", Long.TYPE).primaryKey();
        PrimaryKey primaryKey = cityTable.getPrimaryKey();
        Column pkColumn = (Column)Iterables.first((Iterable)primaryKey.getColumns());
        Map getCities = testInstance.giveMapKeyColumnNames(new AccessorDefinition(Country.class, "getCities", City.class), City.class, primaryKey, Collections.emptySet());
        Assertions.assertThat((Map)getCities).containsEntry((Object)pkColumn, (Object)"city_id");
    }
}

